#ifndef MYWINDOW1_MEMBER_H
#define MYWINDOW1_MEMBER_H
#include<gtkmm.h>
#include "mywindow1_member_function.h"
#include "member.h"
#include "member_inc.h"
#include "login.h"
#include<stdio.h>
#include<string.h>
//MEMBER LOGIN :CONSTRUCTOR

mywindow1::mywindow1()
{   set_modal(true);
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(400, 100);
    set_title("LOGIN");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);

    Gtk::Label *lusername = Gtk::manage(new Gtk::Label("Username: "));
    grid->attach(*lusername, 0, 0, 1, 1);

    Gtk::Label *lpassword = Gtk::manage(new Gtk::Label("Password: "));
    grid->attach(*lpassword, 0, 1, 1, 1);

    Gtk::Entry *eusername = Gtk::manage(new Gtk::Entry());
    eusername->set_hexpand(true);
    grid->attach(*eusername, 1, 0, 2, 1);

    Gtk::Entry *epassword = Gtk::manage(new Gtk::Entry());
    epassword->set_hexpand(true);
    epassword->set_visibility(false);
    grid->attach(*epassword, 1, 1, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("Login"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &mywindow1::on_login_click), eusername, epassword));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
}

//MEMBER LOGIN :DESTRUCTOR

mywindow1::~mywindow1()
{

}

//MEMBER FUNCTION OF MEMBER LOGIN

void mywindow1::on_login_click(Gtk::Entry *euname, Gtk::Entry *epword)
{
    char m_id[30],m_pwd[30];
    copy_ustring(m_id,euname->get_text());
    copy_ustring(m_pwd,epword->get_text());

    if(mem_login(m_id,m_pwd))
    {
        Gtk::MessageDialog dlg("You are now logged in.", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
        dlg.set_title("SUCCESS");
        dlg.run();
        hide();
        FILE *flin;
        flin=fopen("MEM_LOGIN.txt","w");
        fprintf(flin,"%s",m_id);
        fclose(flin);
        open_new_window_mem *popup = new open_new_window_mem;
        popup->popup = new o_window_mem;
        popup->popup->show();


    }
else
    {
        Gtk::MessageDialog dlg("Unknown username or password.", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }

}

o_window_mem::o_window_mem(){
    set_position(Gtk::WIN_POS_CENTER);
    //SIZE OF THE WINDOWS

    set_default_size(500, 200);
    set_title("MEMBER LOGIN");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP
    char m_id[30],m_name[30],m_pwd[30],m_status[30];

    get_curr_mem(m_id);
    get_mem(m_id,m_name,m_pwd,m_status);

    char temp[60]="WELCOME ";
    strcat(temp,m_name);
    //sscanf(m_name,"WELCOME %s",m_name);
    Gtk::Label *lusername = Gtk::manage(new Gtk::Label(temp));
    lusername->set_hexpand(true);
    grid->attach(*lusername, 0, 0, 1, 1);

    Gtk::Label *space = Gtk::manage(new Gtk::Label(""));
    grid->attach(*space, 1, 1, 1, 1);


    //ADDING BUTTONS

    Gtk::Button *b1 = Gtk::manage(new Gtk::Button("BOOK SEARCH"));
    b1->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button1_click));
    grid->attach(*b1, 1, 2, 1, 1);
    Gtk::Button *b2 = Gtk::manage(new Gtk::Button("ISSUE A BOOK"));
    b2->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button2_click));
    grid->attach(*b2, 1, 3, 1, 1);
    Gtk::Button *b3 = Gtk::manage(new Gtk::Button("RETURN A BOOK"));
    b3->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button3_click));
    grid->attach(*b3, 1, 4, 1, 1);
    Gtk::Button *b4 = Gtk::manage(new Gtk::Button("REQUEST A BOOK"));
    b4->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button4_click));
    grid->attach(*b4, 1, 5, 1, 1);
    Gtk::Button *b6 = Gtk::manage(new Gtk::Button("CHANGE PASSWORD"));
    b6->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button6_click));
    grid->attach(*b6, 1, 6, 1, 1);
    Gtk::Button *b7 = Gtk::manage(new Gtk::Button("VIEW DETAILS"));
    b7->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button7_click));
    grid->attach(*b7, 1, 7, 1, 1);
    Gtk::Button *b5 = Gtk::manage(new Gtk::Button("VIEW RULES AND REGULATIONS"));
    b5->signal_clicked().connect(sigc::mem_fun(*this, &o_window_mem::on_button5_click));
    grid->attach(*b5, 1, 8, 1, 1);

    vbox->show_all();
};
o_window_mem::~o_window_mem(){

};

void o_window_mem::on_button1_click(){
    book_mem_search *popup = new book_mem_search;
    popup->popup = new b_mem_search;
    popup->popup->show();
}
void o_window_mem::on_button2_click(){
    issue_book *popup = new issue_book;
    popup->popup = new i_book;
    popup->popup->show();
}
void o_window_mem::on_button3_click(){
    return_mem_book *popup = new return_mem_book;
    popup->popup = new r_mem_book;
    popup->popup->show();
}
void o_window_mem::on_button4_click(){
    request_book *popup = new request_book;
    popup->popup = new rq_book;
    popup->popup->show();
}
void o_window_mem::on_button5_click(){
    view_mem_rar *popup = new view_mem_rar;
    popup->popup = new v_mem_rar;
    popup->popup->show();
}
void o_window_mem::on_button6_click(){
    chng_mem_pwd *popup = new chng_mem_pwd;
    popup->popup = new c_mem_pwd;
    popup->popup->show();
}
void o_window_mem::on_button7_click(){
    view_mem_det *popup = new view_mem_det;
    popup->popup = new v_mem_det;
    popup->popup->show();
}

#endif
